import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    Day: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Day',
        ru: 'День',
        cs: 'Den',
    },
    Month: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Month',
        ru: 'Месяц',
        cs: 'Měsíc',
    },
    Period: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Period',
        ru: 'Период',
        cs: 'Období',
    },
    Week: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Week',
        ru: 'Неделя',
        cs: 'Týden',
    },
    Year: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'Year',
        ru: 'Год',
        cs: 'Rok',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
