import * as React from 'react';

import { ReportPeriod } from 'entities/Report/consts/ReportPeriod';
import { ReportsFilter } from 'entities/Report/consts/ReportsFilter';

import { CheckboxItemOptions } from 'shared/ui/Checkbox/Checkbox';
import { CheckboxGroup, CheckboxGroupProps } from 'shared/ui/CheckboxGroup/CheckboxGroup';
import { FilterGroupProps } from 'shared/ui/FilterGroup/FilterGroup';

import { i18n } from 'entities/Report/ui/ReportsPeriodFilter/ReportsPeriodFilter.i18n';

export interface ReportsPeriodFilterProps
    extends Pick<FilterGroupProps, 'title'>,
        Pick<CheckboxGroupProps, 'disabled'> {
    className?: string;
    values: Nullable<string>;

    onChangeFilter(type: string, value: string): void;
}

export const ReportsPeriodFilter: React.FC<ReportsPeriodFilterProps> = function ReportsPeriodFilter({
    className,
    values,
    onChangeFilter,
    ...otherProps
}) {
    const items: CheckboxItemOptions[] = React.useMemo(
        () => [
            {
                label: i18n('Day'),
                id: ReportPeriod.DAY,
            },

            {
                label: i18n('Week'),
                id: ReportPeriod.WEEK,
            },

            {
                label: i18n('Month'),
                id: ReportPeriod.MONTH,
            },

            {
                label: i18n('Year'),
                id: ReportPeriod.YEAR,
            },
        ],

        [],
    );

    const onChangeHandler = React.useCallback(
        (values: string[]) => {
            onChangeFilter(ReportsFilter.PERIOD, values.join(','));
        },
        [onChangeFilter],
    );

    return (
        <CheckboxGroup
            {...otherProps}
            className={className}
            title={i18n('Period')}
            items={items}
            values={values?.split(',')}
            onChange={onChangeHandler}
        />
    );
};
