import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    Cars: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Cars',
        ru: 'Машины',
        cs: 'Vozy',
    },
    Rides: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Rides',
        ru: 'Поездки',
        cs: 'Jízdy',
    },
    Signals: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Signals',
        ru: 'Сигналы',
        cs: 'Signály',
    },
    Table: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Table',
        ru: 'Таблица',
        cs: 'Tabulka',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
