import * as React from 'react';

import { ReportSection } from 'entities/Report/consts/ReportSection';
import { ReportsFilter } from 'entities/Report/consts/ReportsFilter';

import { CheckboxItemOptions } from 'shared/ui/Checkbox/Checkbox';
import { CheckboxGroup, CheckboxGroupProps } from 'shared/ui/CheckboxGroup/CheckboxGroup';
import { FilterGroupProps } from 'shared/ui/FilterGroup/FilterGroup';

import { i18n } from 'entities/Report/ui/ReportsSectionFilter/ReportsSectionFilter.i18n';

export interface ReportsSectionFilterProps
    extends Pick<FilterGroupProps, 'title'>,
        Pick<CheckboxGroupProps, 'disabled'> {
    className?: string;
    values: Nullable<string>;

    onChangeFilter(type: string, value: string): void;
}

export const ReportsSectionFilter: React.FC<ReportsSectionFilterProps> = function ReportsSectionFilter({
    className,
    values,
    onChangeFilter,
    ...otherProps
}) {
    const items: CheckboxItemOptions[] = React.useMemo(
        () => [
            {
                label: i18n('Signals'),
                id: ReportSection.SIGNALS,
            },

            {
                label: i18n('Rides'),
                id: ReportSection.RIDES,
            },

            {
                label: i18n('Cars'),
                id: ReportSection.CARS,
            },
        ],

        [],
    );

    const onChangeHandler = React.useCallback(
        (values: string[]) => {
            onChangeFilter(ReportsFilter.SECTION, values.join(','));
        },
        [onChangeFilter],
    );

    return (
        <CheckboxGroup
            {...otherProps}
            className={className}
            title={i18n('Table')}
            items={items}
            values={values?.split(',')}
            onChange={onChangeHandler}
        />
    );
};
