import { showCarDriverInRides } from 'utils/showCarDriverInRides';

import { getRidesTableHeaders } from 'components/Rides/RidesTable/constants';

// @todo: add test
export function filterRidesTableColumns<T>(columns: T[]): T[] {
    const allowedCols = getRidesTableHeaders(showCarDriverInRides());
    const allowedColsIndex = allowedCols.reduce((memo: Record<string, boolean>, item) => {
        memo[item.key] = true;

        return memo;
    }, {});

    return columns.filter((column) => {
        const columnKey = typeof column === 'string' ? column : column['key'];

        return allowedColsIndex.hasOwnProperty(columnKey);
    });
}
