import { CarSchema } from 'entities/Car/types/CarSchema';
import { RideAggressiveEventSchema } from 'entities/Ride/types/RideAggressiveEventSchema';
import { RideCameraEventSchema } from 'entities/Ride/types/RideCameraEventSchema';
import { RideSegmentSchema } from 'entities/Ride/types/RideSegmentSchema';
import { RideTrackSchema } from 'entities/Ride/types/RideTrackSchema';
import { UserBaseSchema } from 'entities/User/types/UserBaseSchema';

export interface RideSchema {
    car: Pick<CarSchema, 'id' | 'model_id' | 'number' | 'vin'>;
    user_details?: Pick<UserBaseSchema, 'id' | 'first_name' | 'last_name' | 'pn'>;
    segment: RideSegmentSchema;
    track: RideTrackSchema;
    camera_events: RideCameraEventSchema[];
    aggressive_score?: number;
    aggressive_events: RideAggressiveEventSchema[];
    is_aggressive?: boolean;
    is_speeding?: boolean;
    is_realtime_aggressive?: boolean;
}
