import { RideTrackFeaturePropertiesViolation } from 'entities/Ride/types/RideTrackFeaturePropertiesViolation';

interface RideTrackFeatureSchema {
    id: number;
    properties: {
        description: string;
        status: string;
        violation?: RideTrackFeaturePropertiesViolation;
    };
    geometry: {
        type: string;
        coordinates: [number, number][];
    };
    type: 'Feature';
}

export interface RideTrackSchema {
    type: 'FeatureCollection';
    features: RideTrackFeatureSchema[];

    track_start?: [number, number];
    track_current?: [number, number];
    track_finish?: [number, number];
}
