import { formatServerSignals } from 'entities/Signal/helpers/formatServerSignals/formatServerSignals';
import { SignalDescriptionDictSchema } from 'entities/Signal/types/SignalDescriptionDictSchema';
import { SignalFormattedSchema } from 'entities/Signal/types/SignalFormattedSchema';
import { SignalSchema } from 'entities/Signal/types/SignalSchema';

import { fetchRequest } from 'shared/helpers/fetchRequest/fetchRequest';
import { CacheRequestContext } from 'shared/hooks/useCacheRequestContext/useCacheRequestContext';

export interface FetchSignalReq {
    signal_id?: string;
    page_size: number;
}

export type FetchSignalRes = SignalFormattedSchema;

export interface FetchSignalServerRes {
    signals: SignalSchema[];
    signals_descriptions: SignalDescriptionDictSchema;

    meta?: string;
    can_get_more_pages: boolean;
    next_cars_cursor?: number;
    next_sessions_cursor?: number;
}

function parser(res: FetchSignalServerRes): FetchSignalRes {
    const signals = formatServerSignals(res.signals, res.signals_descriptions);

    if (!signals.length) {
        throw new Error('Signal not found');
    }

    return signals[0];
}

export function fetchSignal(signalId: string, cache?: CacheRequestContext) {
    return fetchRequest<FetchSignalReq, FetchSignalRes, FetchSignalServerRes>(
        '/api/leasing/signals/list',
        {
            signal_id: signalId,
            page_size: 1,
        },
        {
            parser,
            cache,
        },
    );
}
