import { fetchRequest } from 'shared/helpers/fetchRequest/fetchRequest';

export interface PostApproveSignalData {
    tag_id: string;
}

interface PostApproveSignalPayload {
    tag_id: string;
    resolution: string;
}

export function postApproveSignal({ tag_id }: PostApproveSignalData) {
    return fetchRequest<PostApproveSignalPayload, unknown>(
        '/api/leasing/signalq/trace/tag/resolution/set',
        {
            resolution: 'support_approve',
            tag_id,
        },
        {
            method: 'POST',
        },
    );
}
