import { SignalResolution } from 'entities/Signal/consts/SignalResolution';

import { fetchRequest } from 'shared/helpers/fetchRequest/fetchRequest';

export interface PostResolutionSignalData {
    tag_id: string;
    resolution: SignalResolution;
}

interface PostResolutionSignalPayload {
    tag_id: string;
    resolution: SignalResolution;
}

export function postResolutionSignal({ tag_id, resolution }: PostResolutionSignalData) {
    return fetchRequest<PostResolutionSignalPayload, unknown>(
        '/api/leasing/signalq/trace/tag/resolution/set',
        {
            tag_id,
            resolution,
        },
        {
            method: 'POST',
        },
    );
}
