import { formatServerSignals } from 'entities/Signal/helpers/formatServerSignals/formatServerSignals';
import { SignalDescriptionDictSchema } from 'entities/Signal/types/SignalDescriptionDictSchema';
import { SignalFormattedSchema } from 'entities/Signal/types/SignalFormattedSchema';
import { SignalSchema } from 'entities/Signal/types/SignalSchema';

import { useFetch, UseFetchResource } from 'shared/hooks/useFetch/useFetch';

export interface UseSignalReq {
    signal_id?: string;
    page_size: number;
}

export type UseSignalRes = SignalFormattedSchema;

export type UseSignalResource = UseFetchResource<UseSignalRes>;

export interface UseSignalServerRes {
    signals: SignalSchema[];
    signals_descriptions: SignalDescriptionDictSchema;

    meta?: string;
    can_get_more_pages: boolean;
    next_cars_cursor?: number;
    next_sessions_cursor?: number;
}

function parser(res: UseSignalServerRes): UseSignalRes {
    const signals = formatServerSignals(res.signals, res.signals_descriptions);

    if (!signals.length) {
        throw new Error('Signal not found');
    }

    return signals[0];
}

export function useSignal(signalId: string, disabled?: boolean) {
    return useFetch<UseSignalReq, UseSignalRes, UseSignalServerRes>(
        '/api/leasing/signals/list',
        {
            signal_id: signalId,
            page_size: 1,
        },
        {
            parser,
        },
        disabled,
    );
}
