import { SignalDescriptionDictSchema } from 'entities/Signal/types/SignalDescriptionDictSchema';
import { SignalDescriptionSchema } from 'entities/Signal/types/SignalDescriptionSchema';

import { useFetch, UseFetchResource } from 'shared/hooks/useFetch/useFetch';

export interface UseSignalsDescriptionsReq {
    // noop
}

export type UseSignalsDescriptionsRes = SignalDescriptionSchema[];

export interface UseSignalsDescriptionsServerRes {
    signals_descriptions: SignalDescriptionDictSchema;
}

export type UseSignalsDescriptionsResource = UseFetchResource<UseSignalsDescriptionsRes>;

function parser(res: UseSignalsDescriptionsServerRes): UseSignalsDescriptionsRes {
    return Object.values(res.signals_descriptions);
}

export function useSignalsDescriptions() {
    return useFetch<UseSignalsDescriptionsReq, UseSignalsDescriptionsRes, UseSignalsDescriptionsServerRes>(
        '/api/leasing/signals_descriptions/list',
        {},
        {
            parser,
        },
    );
}
