import { ALL_SIGNALS_UNCHECKED_KEY, ONE_MONTH, ONE_SECOND } from 'constants/constants';

import { ManageSignalsFilter } from 'entities/Signal/consts/ManageSignalsFilter';
import { SignalsFilter } from 'entities/Signal/consts/SignalsFilter';

import { DateFilter } from 'shared/consts/DateFilter';
import { getDateEndDay } from 'shared/helpers/getDateEndDay/getDateEndDay';
import { getDateStartDay } from 'shared/helpers/getDateStartDay/getDateStartDay';

// Signals
export const INITIAL_SIGNALS_FILTERS = {
    [DateFilter.SINCE]: (getDateStartDay(new Date()).getTime() - ONE_MONTH) / ONE_SECOND,
    [DateFilter.UNTIL]: Math.trunc(getDateEndDay(new Date()).getTime() / ONE_SECOND),
    [SignalsFilter.SIGNALS]: ALL_SIGNALS_UNCHECKED_KEY,
    [SignalsFilter.ACTUAL_ONLY]: false,
    [SignalsFilter.PRIORITY]: null,
    [SignalsFilter.SOURCE]: null,
    [SignalsFilter.CAR]: null,
};
export const EXISTING_SIGNALS_FILTERS = [
    DateFilter.SINCE,
    DateFilter.UNTIL,
    SignalsFilter.SIGNALS,
    SignalsFilter.ACTUAL_ONLY,
    SignalsFilter.PRIORITY,
    SignalsFilter.SOURCE,
    SignalsFilter.CAR,
];
export const STRING_SIGNALS_FILTERS = [
    SignalsFilter.SIGNALS,
    SignalsFilter.PRIORITY,
    SignalsFilter.SOURCE,
    SignalsFilter.CAR,
];
export const BOOLEAN_SIGNALS_FILTERS = [SignalsFilter.ACTUAL_ONLY];
export const DATE_SIGNALS_FILTERS = [DateFilter.SINCE, DateFilter.UNTIL];

// Manage Signals
export const INITIAL_MANAGE_SIGNALS_FILTERS = {
    [ManageSignalsFilter.PRIORITY]: null,
};
export const EXISTING_MANAGE_SIGNALS_FILTERS = [ManageSignalsFilter.PRIORITY];
export const STRING_MANAGE_SIGNALS_FILTERS = [ManageSignalsFilter.PRIORITY];
