import { EMPTY_DATA, ONE_SECOND } from 'constants/constants';

import { durationUTCBetween } from 'utils/date/durationUTCBetween';
import { getI18nLocale } from 'utils/language/getI18nLocale';

import { SignalFormattedSchema } from 'entities/Signal/types/SignalFormattedSchema';

import { SCORING_TRACE_TAG } from 'components/Cars/constants';
import { getSessionTime } from 'components/Signals/SignalsTable/getSessionTime';
import { getFormattedDuration } from 'components/ui/DurationUTCBetween';

export function buildSignalXLSX(signals: SignalFormattedSchema[]): Dict<string | number>[] {
    const locale = getI18nLocale();

    return signals.map((signal) => {
        const { since, until, name, description, car, trace } = signal;
        const { display_name, is_permanent, priority } = description;

        const time = since
            ? new Date(since * ONE_SECOND)?.toLocaleString(locale, {
                  day: 'numeric',
                  month: 'short',
                  hour: '2-digit',
                  minute: '2-digit',
              })
            : EMPTY_DATA;

        return {
            date_time: time,
            level: priority,
            duration:
                !is_permanent && name !== SCORING_TRACE_TAG
                    ? getFormattedDuration(durationUTCBetween(since, until))
                    : EMPTY_DATA,
            event: display_name ?? name,
            car: car?.details?.number!,
            session: getSessionTime(trace?.details?.since, trace?.details?.until),
        };
    });
}
