import { getCarSignalDisplayName } from 'entities/Car/helpers/getCarSignalDisplayName/getCarSignalDisplayName';
import { getCarSignalPriority } from 'entities/Car/helpers/getCarSignalPriority/getCarSignalPriority';
import { SignalDescriptionDictSchema } from 'entities/Signal/types/SignalDescriptionDictSchema';
import { SignalFormattedSchema } from 'entities/Signal/types/SignalFormattedSchema';
import { SignalSchema } from 'entities/Signal/types/SignalSchema';

export function formatServerSignals(
    signals: SignalSchema[],
    descriptions: SignalDescriptionDictSchema,
): SignalFormattedSchema[] {
    return signals.map((signal) => {
        const { name, linked_entities } = signal;
        const description = descriptions[name];

        const entitiesObject = linked_entities.reduce(
            (result, linkedEntity) => {
                const { entity_type } = linkedEntity;

                result[entity_type] = linkedEntity;

                return result;
            },
            { car: undefined, trace: undefined },
        );

        return {
            ...entitiesObject,
            ...signal,
            description: {
                ...description,
                priority: getCarSignalPriority(signal, description),
                display_name: getCarSignalDisplayName(signal, description),
            },
        };
    });
}
