import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'The signal comes when the brake test light on the dashboard is on': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'The signal comes when the brake test light on the dashboard is on',
        ru: 'Сигнал приходит, когда на приборной панели горит лампочка проверки тормозной системы',
        cs: 'Signál je vysílán, když se rozsvítí kontrolka zkontrolovat brzdy na palubní desce',
    },
    'The signal comes when the car battery level falls within the specified limits': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'The signal comes when the car battery level falls within the specified limits',
        ru: 'Сигнал приходит, когда заряд автомобильного аккумулятора попадает в заданные границы',
        cs: 'Signál je vysílán, když se úroveň nabití baterie vozu pohybuje ve stanovených limitech',
    },
    'The signal comes when the car enters a certain area': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'The signal comes when the car enters a certain area',
        ru: 'Сигнал приходит, когда машина въезжает в указанную зону',
        cs: 'Signál je vysílán, když vůz vstoupí do určité oblasti',
    },
    'The signal comes when the car exceeds the specified speed': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'The signal comes when the car exceeds the specified speed',
        ru: 'Сигнал приходит, когда машина превышает указанную скорость',
        cs: 'Signál je vysílán, když vůz překročí stanovenou rychlost',
    },
    'The signal comes when the car leaves a certain area': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'The signal comes when the car leaves a certain area',
        ru: 'Сигнал приходит, когда машина покидает указанную зону',
        cs: 'Signál je vysílán, když vůz opustí určitou oblast',
    },
    'The signal comes when the car travels more than a certain number of kilometers in a specified number of days': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'The signal comes when the car travels more than a certain number of kilometers in a specified number of days',
        ru: 'Сигнал приходит, когда машина проезжает за выбранный период больше определённого количества километров',
        cs: 'Signál je vysílán, když vůz ujede více než určitý počet kilometrů za určitý počet dní',
    },
    "The signal comes when the car's mileage decreases": {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: "The signal comes when the car's mileage decreases",
        ru: 'Сигнал приходит, когда пробег автомобиля снижается',
        cs: 'Signál je vysílán, když se počet ujetých kilometrů vozu sníží',
    },
    'The signal comes when the check airbag light on the dashboard is on': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'The signal comes when the check airbag light on the dashboard is on',
        ru: 'Сигнал приходит, когда на приборной панели горит лампочка check airbag',
        cs: 'Signál je vysílán, když se rozsvítí kontrolka zkontrolovat airbag na palubní desce',
    },
    'The signal comes when the check engine light is on the dashboard': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'The signal comes when the check engine light is on the dashboard',
        ru: 'Сигнал приходит, когда на приборной панели горит лампочка check engine',
        cs: 'Signál je vysílán, když se rozsvítí kontrolka zkontrolovat motor na palubní desce',
    },
    'The signal comes when the engine is overheated': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'The signal comes when the engine is overheated',
        ru: 'Сигнал приходит, когда двигатель перегрет',
        cs: 'Signál přichází, když je motor přehřátý',
    },
    'The signal comes when the indicated errors appear in the diagnostic bus of the car': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'The signal comes when the indicated errors appear in the diagnostic bus of the car',
        ru: 'Сигнал приходит, когда в диагностической шине автомобиля появятся указанные ошибки',
        cs: 'Signál je vysílán, když se v diagnostické sběrnici vozu objeví indikované chyby',
    },
    'The signal comes when the low tire pressure light on the dashboard is on': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'The signal comes when the low tire pressure light on the dashboard is on',
        ru: 'Сигнал приходит, когда на приборной панели горит лампочка низкого давления шин',
        cs: 'Signál je vysílán, když se rozsvítí kontrolka nízkého tlaku v pneumatikách na palubní desce',
    },
    'The signal comes when the low washer fluid light on the dashboard is on': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'The signal comes when the low washer fluid light on the dashboard is on',
        ru: 'Сигнал приходит, когда на приборной панели горит лампочка низкого уровня омывающей жидкости',
        cs: 'Signál je vysílán, když se rozsvítí kontrolka nízké hladiny ostřikovací kapaliny na palubní desce',
    },
    'The signal comes when the oil check light on the dashboard is on': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'The signal comes when the oil check light on the dashboard is on',
        ru: 'Сигнал приходит, когда на приборной панели горит лампочка проверки масла',
        cs: 'Signál je vysílán, když se rozsvítí kontrolka zkontrolovat olej na palubní desce',
    },
    'The signal comes when the telematics does not respond for the specified amount of time': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'The signal comes when the telematics does not respond for the specified amount of time',
        ru: 'Сигнал приходит, когда телематика не отвечает указанное количество времени',
        cs: 'Signál je vysílán, když telematika nereaguje po stanovenou dobu',
    },
    "The signal comes when the vehicle's VIN changes.": {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: "The signal comes when the vehicle's VIN changes.",
        ru: 'Сигнал приходит, когда меняется VIN автомобиля',
        cs: 'Signál přichází ve chvíli, kdy se změní VIN vozidla.',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
