import { SignalType } from 'entities/Signal/types/SignalType';

import { i18n } from 'entities/Signal/helpers/getSignalTypeDesc/getSignalTypeDesc.i18n';

const TRANSLATES: Record<SignalType, string> = {
    speeding_signal: i18n('The signal comes when the car exceeds the specified speed'),
    telematics_lag_signal: i18n(
        'The signal comes when the telematics does not respond for the specified amount of time',
    ),

    car_battery_died_signal: i18n('The signal comes when the car battery level falls within the specified limits'),

    car_out_zone_signal: i18n('The signal comes when the car leaves a certain area'),
    car_in_zone_signal: i18n('The signal comes when the car enters a certain area'),
    car_over_mileage_signal: i18n(
        'The signal comes when the car travels more than a certain number of kilometers in a specified number of days',
    ),

    dashboard_check_engine_signal: i18n('The signal comes when the check engine light is on the dashboard'),
    dashboard_check_airbag_signal: i18n('The signal comes when the check airbag light on the dashboard is on'),
    dashboard_tyre_pressure_signal: i18n('The signal comes when the low tire pressure light on the dashboard is on'),
    dashboard_washer_liquid_signal: i18n('The signal comes when the low washer fluid light on the dashboard is on'),

    dashboard_check_oil_signal: i18n('The signal comes when the oil check light on the dashboard is on'),
    dashboard_check_brake_signal: i18n('The signal comes when the brake test light on the dashboard is on'),
    warning_dtc_error_signal: i18n(
        'The signal comes when the indicated errors appear in the diagnostic bus of the car',
    ),

    car_changed_mileage_signal: i18n("The signal comes when the car's mileage decreases"),

    engine_overheating_signal: i18n('The signal comes when the engine is overheated'),
    change_vin_signal: i18n("The signal comes when the vehicle's VIN changes."),
};

export function getSignalTypeDesc(type?: SignalType): Optional<string> {
    if (!type) {
        return undefined;
    }

    return TRANSLATES[type];
}
