import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Car battery': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Car battery',
        ru: 'Заряд аккумулятора',
        cs: 'Baterie vozu',
    },
    'Change VIN': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Change VIN',
        ru: 'Смена VIN',
        cs: 'Změňa VIN',
    },
    'Check airbag': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Check airbag',
        ru: 'Проверьте подушку безопасности',
        cs: 'Zkontrolujte airbag',
    },
    'Check brake system': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Check brake system',
        ru: 'Проверьте тормозную систему',
        cs: 'Zkontrolujte brzdový systém',
    },
    'Check engine': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Check engine',
        ru: 'Проверьте двигатель',
        cs: 'Zkontrolujte motor',
    },
    'Check oil': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Check oil',
        ru: 'Проверьте масло',
        cs: 'Zkontrolujte olej',
    },
    'Check tire pressure': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Check tire pressure',
        ru: 'Проверьте давление в шинах',
        cs: 'Zkontrolujte tlak v pneumatikách',
    },
    'Check washer fluid level': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Check washer fluid level',
        ru: 'Проверьте уровень омывающей жидкости',
        cs: 'Zkontrolujte hladinu ostřikovací kapaliny',
    },
    'DTC error': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'DTC error',
        ru: 'Ошибка диагностики',
        cs: 'Chyba DTC',
    },
    'Engine overheating': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Engine overheating',
        ru: 'Перегрев двигателя',
        cs: 'Přehřátí motoru',
    },
    'Entering geofence': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Entering geofence',
        ru: 'Въезд в зону',
        cs: 'Vstup do zóny',
    },
    'Leaving geofence': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Leaving geofence',
        ru: 'Выезд из зоны',
        cs: 'Opuštění zóny',
    },
    'Mileage fraud': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Mileage fraud',
        ru: 'Скрутка пробега',
        cs: 'Manipulace s počtem ujetých kilometrů',
    },
    Overmileage: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Overmileage',
        ru: 'Перепробег',
        cs: 'Počet ujetých kilometrů nad limit',
    },
    Speeding: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Speeding',
        ru: 'Превышение скорости',
        cs: 'Překročení povolené rychlosti',
    },
    'Telematics lag': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Telematics lag',
        ru: 'Лаг телематики',
        cs: 'Zpoždění telematiky',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
