import { SignalType } from 'entities/Signal/types/SignalType';

import { i18n } from 'entities/Signal/helpers/getSignalTypeTitle/getSignalTypeTitle.i18n';

const TRANSLATES: Record<SignalType, string> = {
    speeding_signal: i18n('Speeding'),
    telematics_lag_signal: i18n('Telematics lag'),
    car_battery_died_signal: i18n('Car battery'),
    car_out_zone_signal: i18n('Leaving geofence'),
    car_in_zone_signal: i18n('Entering geofence'),
    car_over_mileage_signal: i18n('Overmileage'),
    dashboard_check_engine_signal: i18n('Check engine'),
    dashboard_check_airbag_signal: i18n('Check airbag'),
    dashboard_tyre_pressure_signal: i18n('Check tire pressure'),
    dashboard_washer_liquid_signal: i18n('Check washer fluid level'),
    warning_dtc_error_signal: i18n('DTC error'),
    dashboard_check_brake_signal: i18n('Check brake system'),
    dashboard_check_oil_signal: i18n('Check oil'),
    car_changed_mileage_signal: i18n('Mileage fraud'),
    engine_overheating_signal: i18n('Engine overheating'),
    change_vin_signal: i18n('Change VIN'),
};

export function getSignalTypeTitle(type?: SignalType): Optional<string> {
    if (!type) {
        return undefined;
    }

    return TRANSLATES[type];
}
