import { SignalDescriptionSchema } from 'entities/Signal/types/SignalDescriptionSchema';
import { SignalSchema } from 'entities/Signal/types/SignalSchema';

// aka FormattedSignal
export interface SignalFormattedSchema extends Omit<SignalSchema, 'linked_entities'> {
    description: SignalDescriptionSchema;

    car?: {
        object_id: string;
        details: {
            model: string;
            number: string;
        };
    };

    trace?: {
        object_id: string;
        details: {
            since: number;
            until: number;
        };
    };
}
