import * as React from 'react';

import { ManageSignalsFilter } from 'entities/Signal/consts/ManageSignalsFilter';

import { CheckboxItemOptions } from 'shared/ui/Checkbox/Checkbox';
import { CheckboxGroup, CheckboxGroupProps } from 'shared/ui/CheckboxGroup/CheckboxGroup';
import { FilterGroupProps } from 'shared/ui/FilterGroup/FilterGroup';

import { i18n } from 'entities/Signal/ui/ManageSignalsPriorityFilter/ManageSignalsPriorityFilter.i18n';

export interface ManageSignalsPriorityFilterProps
    extends Pick<FilterGroupProps, 'title'>,
        Pick<CheckboxGroupProps, 'disabled'> {
    className?: string;
    values: Nullable<string>;

    onChangeFilter(type: string, value: string): void;
}

const DEFAULT_VALUE = 'all';

export const ManageSignalsPriorityFilter: React.FC<ManageSignalsPriorityFilterProps> =
    function ManageSignalsPriorityFilter({ className, values, onChangeFilter, ...otherProps }) {
        const items: CheckboxItemOptions[] = React.useMemo(
            () => [
                {
                    label: i18n('Critical'),
                    id: 'critical',
                },

                {
                    label: i18n('Normal'),
                    id: 'normal',
                },
            ],

            [],
        );

        const onChangeHandler = React.useCallback(
            (values: string[]) => {
                onChangeFilter(ManageSignalsFilter.PRIORITY, values.join(',') || DEFAULT_VALUE);
            },
            [onChangeFilter],
        );

        return (
            <CheckboxGroup
                {...otherProps}
                className={className}
                title={i18n('Signal priority')}
                items={items}
                values={values?.split(',')}
                onChange={onChangeHandler}
            />
        );
    };
