import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Create new signal': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Create new signal',
        ru: 'Создать новый сигнал',
        cs: 'Vytvořit nový signál',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
