import * as React from 'react';

import { ButtonColor } from 'shared/consts/ButtonColor';
import { ButtonSize } from 'shared/consts/ButtonSize';
import { MetrikaLabel } from 'shared/consts/MetrikaLabel';
import { metrikaLableClick } from 'shared/helpers/metrikaLabelClick/metrikaLableClick';
import { Button, ButtonProps } from 'shared/ui/Button/Button';

import { i18n } from 'entities/Signal/ui/SignalAddButton/SignalAddButton.i18n';

import PlusIcon from 'shared/ui/Icons/images/plus-outline-16.inline.svg';

export interface SignalAddButtonProps extends Pick<ButtonProps, 'onClick'> {
    className?: string;
}

export const SignalAddButton: React.FC<SignalAddButtonProps> = function SignalAddButton({ className, onClick }) {
    const onClickHandler = React.useCallback(
        (event: React.MouseEvent<HTMLAnchorElement | HTMLButtonElement>) => {
            try {
                metrikaLableClick(MetrikaLabel.ADD_SIGNAL);
            } catch (e) {
                console.error(e);
            }

            if (onClick) {
                onClick(event);
            }
        },
        [onClick],
    );

    return (
        <Button
            className={className}
            color={ButtonColor.PRIMARY}
            size={ButtonSize.M}
            icon={PlusIcon}
            label={i18n('Create new signal')}
            onClick={onClickHandler}
        />
    );
};
