import * as React from 'react';

import { SignalsFilter } from 'entities/Signal/consts/SignalsFilter';

import { Checkbox, CheckboxProps } from 'shared/ui/Checkbox/Checkbox';

import { i18n } from 'entities/Signal/ui/SignalsActualFilter/SignalsActualFilter.i18n';

export interface SignalsActualFilterProps extends Pick<CheckboxProps, 'checked' | 'disabled'> {
    className?: string;

    onChangeFilter?(type: string, value: boolean): void; // remove after redesign
    onChangeFilterForm?(value: boolean): void;
}

export const SignalsActualFilter: React.FC<SignalsActualFilterProps> = function SignalsActualFilter({
    className,
    onChangeFilter,
    onChangeFilterForm,
    ...otherProps
}) {
    const onChangeHandler = React.useCallback(
        (checked: boolean) => {
            if (onChangeFilter) {
                onChangeFilter(SignalsFilter.ACTUAL_ONLY, checked);
            }

            if (onChangeFilterForm) {
                onChangeFilterForm(checked);
            }
        },
        [onChangeFilter, onChangeFilterForm],
    );

    return (
        <Checkbox
            {...otherProps}
            id={SignalsFilter.ACTUAL_ONLY}
            label={i18n('Only actual')}
            onChange={onChangeHandler}
        />
    );
};
