import * as React from 'react';

import { SignalsFilter } from 'entities/Signal/consts/SignalsFilter';

import { InputSize } from 'shared/consts/InputSize';
import { debounce } from 'shared/helpers/debounce/debounce';
import { InputSearch } from 'shared/ui/InputSearch/InputSearch';

import { i18n } from 'entities/Signal/ui/SignalsCarFilter/SignalsCarFilter.i18n';

export interface SignalsCarFilterProps {
    className?: string;
    value: Nullish<string>;
    onChangeFilter(type: string, value: string): void;
}

const DEBOUNCE_INTERVAL = 500;

export const SignalsCarFilter: React.FC<SignalsCarFilterProps> = function SignalsCarFilter({
    className,
    value,
    onChangeFilter,
}) {
    const [text, setText] = React.useState<string>(value || '');

    const onChangeFilterDebounced = React.useCallback(debounce(onChangeFilter, DEBOUNCE_INTERVAL), [onChangeFilter]);

    const onChange = React.useCallback(
        (value: string) => {
            setText(value);

            if (value) {
                onChangeFilterDebounced(SignalsFilter.CAR, value);
            } else {
                onChangeFilter(SignalsFilter.CAR, value);
            }
        },
        [onChangeFilterDebounced],
    );

    React.useEffect(() => {
        setText(value || '');
    }, [value]);

    return (
        <InputSearch
            className={className}
            inputSize={InputSize.M}
            placeholder={i18n('License plate number')}
            value={text}
            onInputChange={onChange}
        />
    );
};
