import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    Critical: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Critical',
        ru: 'Критический',
        cs: 'Kritické',
    },
    Levels: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Levels',
        ru: 'Уровни',
        cs: 'Úrovně',
    },
    Normal: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Normal',
        ru: 'Обычный',
        cs: 'Normální',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
