import * as React from 'react';
import cn from 'classnames';

import { SignalsFilter } from 'entities/Signal/consts/SignalsFilter';

import { CheckboxItemOptions } from 'shared/ui/Checkbox/Checkbox';
import { CheckboxGroup } from 'shared/ui/CheckboxGroup/CheckboxGroup';
import { TextWithDot } from 'shared/ui/TextWithDot/TextWithDot';

import { i18n } from 'entities/Signal/ui/SignalsLevelFilter/SignalsLevelFilter.i18n';

import styles from 'entities/Signal/ui/SignalsLevelFilter/SignalsLevelFilter.css';

export interface SignalsLevelFilterProps {
    className?: string;

    values?: Nullable<string>;

    onChange?: (value: string) => void;
    onChangeFilter?(type: string, value: string): void; // remove after redesign
}

export const SignalsLevelFilter: React.FC<SignalsLevelFilterProps> = function SignalsLevelFilter({
    className,
    values,
    onChange,
    onChangeFilter,
}) {
    const items: CheckboxItemOptions[] = [
        {
            label: <TextWithDot className={cn(styles.item, styles.critical)}>{i18n('Critical')}</TextWithDot>,
            id: 'critical',
        },
        {
            label: <TextWithDot className={cn(styles.item, styles.normal)}>{i18n('Normal')}</TextWithDot>,
            id: 'normal',
        },
    ];

    const onChangeHandler = React.useCallback(
        (values: string[]) => {
            if (onChange) {
                onChange(values.join());
            }

            if (onChangeFilter) {
                onChangeFilter(SignalsFilter.PRIORITY, values.join());
            }
        },
        [onChange, onChangeFilter],
    );

    return (
        <CheckboxGroup
            className={className}
            title={i18n('Levels')}
            items={items}
            values={values?.split(',')}
            onChange={onChangeHandler}
        />
    );
};
