import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    Camera: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Camera',
        ru: 'Камера',
        cs: 'Kamera',
    },
    Source: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Source',
        ru: 'Источник',
        cs: 'Zdroj',
    },
    Telematics: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Telematics',
        ru: 'Телематика',
        cs: 'Telematika',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
