import * as React from 'react';

import { getSignalsSourceFilterFlag } from 'utils/getSignalsSourceFilterFlag';

import { SignalsFilter } from 'entities/Signal/consts/SignalsFilter';

import { CheckboxItemOptions } from 'shared/ui/Checkbox/Checkbox';
import { CheckboxGroup } from 'shared/ui/CheckboxGroup/CheckboxGroup';

import { i18n } from 'entities/Signal/ui/SignalsSourceFilter/SignalsSourceFilter.i18n';

export interface SignalsSourceFilterProps {
    className?: string;

    values?: Nullable<string>;

    onChange?: (value: string) => void;
    onChangeFilter?(type: string, value: string): void; // remove after redesign
}

export const SignalsSourceFilter: React.FC<SignalsSourceFilterProps> = function SignalsSourceFilter({
    className,
    values,
    onChange,
    onChangeFilter,
}) {
    const allowedIds = getSignalsSourceFilterFlag();

    const items: CheckboxItemOptions[] = React.useMemo(() => {
        let items = [
            {
                label: i18n('Telematics'),
                id: 'telematics',
            },
            {
                label: i18n('Camera'),
                id: 'signalQ',
            },
        ];

        if (allowedIds && Array.isArray(allowedIds)) {
            items = items.filter((item) => allowedIds.includes(item.id));
        }

        return items;
    }, [allowedIds]);

    const onChangeHandler = React.useCallback(
        (values: string[]) => {
            if (onChange) {
                onChange(values.join());
            }

            if (onChangeFilter) {
                onChangeFilter(SignalsFilter.SOURCE, values.join());
            }
        },
        [onChange, onChangeFilter],
    );

    return (
        <CheckboxGroup
            className={className}
            title={i18n('Source')}
            items={items}
            values={values?.split(',')}
            onChange={onChangeHandler}
        />
    );
};
