import { useFetchRequest } from 'shared/hooks/useFetchRequest/useFetchRequest';

export interface UseAffiliationTagsReq {}

export interface UseAffiliationTagsRes {
    records: TagDescription[];
}

export interface TagDescription {
    meta: string;
    entities: string[];
    type: string;
    description_index: string;
    display_name: string;
    name: string;
    tag?: string;
    revision: string;
    comment: string;
    unique_policy: string;
    default_priority: string;
}

const ORGANIZATION_TAG = 'user_organization_affiliation_tag';

export function useAffiliationTags() {
    return useFetchRequest<UseAffiliationTagsReq, TagDescription[], UseAffiliationTagsRes>(
        '/api/leasing/tag/description/list',
        {},
        {
            parser(res: UseAffiliationTagsRes): TagDescription[] {
                return (
                    res?.records?.filter?.((tag) => {
                        return tag.type === ORGANIZATION_TAG;
                    }) ?? []
                );
            },
        },
    );
}
