import { UserSearchSchema } from 'entities/User/types/UserSearchSchema';

import { buildFetchRequestResult, fetchRequest } from 'shared/helpers/fetchRequest/fetchRequest';
import { CacheRequestContext } from 'shared/hooks/useCacheRequestContext/useCacheRequestContext';

export interface FetchUsersSearchData {
    has_all_of: string;
    has_one_of?: string;
    what: 'users';
    limit: number;
}

export interface FetchUsersSearchServerRes {
    objects: {
        users: UserSearchSchema[];
    };
}

export type FetchUsersSearchRes = FetchUsersSearchServerRes['objects']['users'];

export function fetchUsersSearch(text: string, cache: CacheRequestContext) {
    if (!text) {
        return buildFetchRequestResult(Promise.resolve([]));
    }

    return fetchRequest<FetchUsersSearchData, FetchUsersSearchRes, FetchUsersSearchServerRes>(
        '/api/leasing/search',
        {
            has_all_of: text,
            has_one_of: 'active,external,blocked,screening,onboarding,external',
            what: 'users',
            limit: 10,
        },
        {
            cache,
            parser(res) {
                return res.objects?.users ?? [];
            },
        },
    );
}
