import { UserDrivingLicenseFormSchema } from 'entities/User/types/UserDrivingLicenseFormSchema';
import { UserDrivingLicenseSchema } from 'entities/User/types/UserDrivingLicenseSchema';
import { UserPassportFormSchema } from 'entities/User/types/UserPassportFormSchema';
import { UserPassportSchema } from 'entities/User/types/UserPassportSchema';

import { fetchRequest } from 'shared/helpers/fetchRequest/fetchRequest';
import { formatDateToString } from 'shared/helpers/formatDateToString/formatDateToString';

export interface PostUserBaseData {
    id: string;
    first_name?: string;
    last_name?: string;
    pn?: string;
    address?: string;
    phone?: string;
    email?: string;
}

export interface PostUserData extends PostUserBaseData {
    passport?: UserPassportSchema;
    driving_license?: UserDrivingLicenseSchema;
}

export interface PostUserFormData extends PostUserBaseData {
    passport?: UserPassportFormSchema;
    driving_license?: UserDrivingLicenseFormSchema;
}

function formatArrayToString(value: Optional<string | string[]>): string {
    if (!value) {
        return '';
    }

    return Array.isArray(value) ? value.sort((a, b) => a.localeCompare(b)).join(',') : value;
}

export function postUser({ passport, driving_license, ...data }: PostUserFormData) {
    let formData: PostUserData = data;

    if (passport) {
        formData.passport = {
            ...passport,
            gender: formatArrayToString(passport.gender),
            birth_date: formatDateToString(passport.birth_date),
            issue_date: formatDateToString(passport.issue_date),
        };
    }

    if (driving_license) {
        formData.driving_license = {
            ...driving_license,
            birth_date: formatDateToString(driving_license.birth_date),
            categories: formatArrayToString(driving_license.categories),
            issue_date: formatDateToString(driving_license.issue_date),
            categories_b_valid_from_date: formatDateToString(driving_license.categories_b_valid_from_date),
            categories_b_valid_to_date: formatDateToString(driving_license.categories_b_valid_to_date),
        };
    }

    return fetchRequest<PostUserData, unknown>('/api/leasing/user/edit', formData, {
        method: 'POST',
        query: { validate: 'false' },
    });
}
