import { UserDetailsFormSchema } from 'entities/User/types/UserDetailsFormSchema';

import { fetchRequest } from 'shared/helpers/fetchRequest/fetchRequest';
import { CacheRequestContext } from 'shared/hooks/useCacheRequestContext/useCacheRequestContext';

export interface UserCreateData {
    last_name: string;
    first_name: string;
    phone_number?: string;
    email?: string;
    roles: string[];
}

export function postUserCreate(userData: OptionalRecord<UserDetailsFormSchema>, cache: CacheRequestContext) {
    const { last_name, first_name, phone, email, role } = userData;
    const data = {
        last_name: last_name ?? '',
        first_name: first_name ?? '',
        phone_number: phone,
        email,
        roles: typeof role === 'string' ? [role] : [],
    };

    return fetchRequest<UserCreateData, unknown>('api/leasing/organization/driver/create', data, {
        method: 'POST',
        cache,
    });
}
