import { UserPhotoContentTypeSchema } from 'entities/User/types/UserPhotosSchema';

import { fetchRequest } from 'shared/helpers/fetchRequest/fetchRequest';

export type PostUserDocumentPhotoType = 'license_back' | 'license_front' | 'passport_biographical' | 'passport_selfie';

export type PostUserDocumentPhotoData = File;

const PHOTO_TYPE: Record<UserPhotoContentTypeSchema, PostUserDocumentPhotoType> = {
    lb: 'license_back',
    lf: 'license_front',
    pb: 'passport_biographical',
    ps: 'passport_selfie',
};

export async function postUserDocumentPhoto(photos: Partial<Record<UserPhotoContentTypeSchema, File>>, userId: string) {
    const files = Object.keys(photos).map((type) => ({ file: photos[type], type }));

    if (files.length) {
        // @todo: write a queue
        for (let i = 0; i < files.length; i++) {
            const file = files[i].file;
            const type = PHOTO_TYPE[files[i].type];

            await fetchRequest<PostUserDocumentPhotoData, unknown>('/api/leasing/user/document-photo/upload', file, {
                method: 'POST',
                query: {
                    type,
                },
                headers: { UserIdDelegation: userId },
            });
        }
    }
}
