import { fetchRequest } from 'shared/helpers/fetchRequest/fetchRequest';

export interface PostUserTagReq {
    object_id: string;
    roles: string[];
    tag: string;
    priority?: number;
}

export function postUserTag({ object_id, roles, tag, priority }: PostUserTagReq) {
    return fetchRequest<PostUserTagReq, unknown>(
        '/api/leasing/user/tag/add',
        {
            object_id,
            roles,
            tag,
            priority: priority ?? 0,
        },
        { method: 'POST' },
    );
}
