import { useFetchRequest } from 'shared/hooks/useFetchRequest/useFetchRequest';

export interface UseUserDocumentPhotoData {
    user_id: string;
    photo_id: string;
}

export type UseUserDocumentPhotoServerRes = Blob;

export type UseUserDocumentPhotoRes = string;

export function useUserDocumentPhoto(userId?: string, photoId?: string) {
    const disabled = !photoId || !userId;
    const data = disabled ? undefined : { user_id: userId, photo_id: photoId };

    return useFetchRequest<Optional<UseUserDocumentPhotoData>, UseUserDocumentPhotoRes, UseUserDocumentPhotoServerRes>(
        '/api/leasing/user/document-photo/get',
        data,
        { timeout: 10000, parser: (blob) => URL.createObjectURL(blob) },
        disabled,
    );
}
