import { DAYS_IN_MONTH } from 'constants/constants';

import { useFetch, UseFetchResource } from 'shared/hooks/useFetch/useFetch';

export interface UseUserMedianScoringReq {
    user_id: string;
    limit: number;
}

export interface UseUserMedianScoringServerRes {
    median_ranks: Array<{
        rank: number;
        day: number;
        timestamp: number;
    }>;
}

export type UseUserMedianScoringRes = UseUserMedianScoringServerRes['median_ranks'];

export type UseUserMedianScoringResource = UseFetchResource<UseUserMedianScoringRes>;

export function useUserMedianScoring(id: string) {
    return useFetch<UseUserMedianScoringReq, UseUserMedianScoringRes, UseUserMedianScoringServerRes>(
        '/api/leasing/taxi_company/stats',
        {
            user_id: id,
            limit: DAYS_IN_MONTH,
        },
        {
            parser(res) {
                return res.median_ranks;
            },
        },
    );
}
