import { UserMemberSchema } from 'entities/User/types/UserMemberSchema';

import { useFetch, UseFetchResource } from 'shared/hooks/useFetch/useFetch';

export interface UseUserMemberReq {
    users_ids: string;
}

export interface UseUserMemberServerRes {
    members: UserMemberSchema[];
}

export type UseUserMemberRes = UserMemberSchema;

export type UseUserMemberResource = UseFetchResource<UseUserMemberRes>;

export function useUserMember(id: string) {
    return useFetch<UseUserMemberReq, UseUserMemberRes, UseUserMemberServerRes>(
        '/api/leasing/organization/members/list',
        { users_ids: id },
        {
            method: 'POST',
            query: { user_score: 'true' },
            parser(res) {
                return res.members[0];
            },
        },
    );
}
