import { UserPerformedCarTag } from 'entities/User/types/UserPerformedCarTag';

import { useFetch, UseFetchResource } from 'shared/hooks/useFetch/useFetch';

interface UseUserPerformedTagsReq {
    performer: string;
}

export interface UseUserPerformedTagsRes {
    records: UserPerformedCarTag[];
    user_tags: any[];
}

export type UsePerformedTagsResource = UseFetchResource<UseUserPerformedTagsRes>;

export function useUserPerformedTags(performer: string) {
    return useFetch<UseUserPerformedTagsReq, UseUserPerformedTagsRes>('/api/leasing/tags/by_performer', { performer });
}
