import { useFetchRequest } from 'shared/hooks/useFetchRequest/useFetchRequest';

interface FetchUserPossibleRolesData {}

interface FetchUserPossibleRolesRes {
    roles: string[];
}

export function useUserPossibleRoles() {
    return useFetchRequest<FetchUserPossibleRolesData, string[], FetchUserPossibleRolesRes>(
        '/api/leasing/organization/possible_roles',
        {},
        {
            parser(res: FetchUserPossibleRolesRes): string[] {
                return res?.roles;
            },
        },
    );
}
