import { ONE_MONTH, ONE_SECOND } from 'constants/constants';

import { UserTagSchema } from 'entities/User/types/UserTagSchema';

import { useFetch, UseFetchResource } from 'shared/hooks/useFetch/useFetch';

export interface UseUserScoringReq {
    object_id: string;
    tags: string;
    since: number;
    until: number;
}

export interface UseUserScoringServerRes {
    records: Array<{
        object_id: string;
        tag_id: string;
        tag_name: string;
        tag_display_name: string;
        tag_details?: UserTagSchema;
        timestamp: number;
    }>;
}

export type UseUserScoringRes = UseUserScoringServerRes['records'];

export type UseUserScoringResource = UseFetchResource<UseUserScoringRes>;

export function useUserScoring(id: string) {
    const currentDate = Date.now();

    return useFetch<UseUserScoringReq, UseUserScoringRes, UseUserScoringServerRes>(
        '/api/leasing/user/tags_history',
        {
            object_id: id,
            tags: 'scoring_user_tag',
            since: Math.trunc((currentDate - ONE_MONTH) / ONE_SECOND),
            until: Math.trunc(currentDate / ONE_SECOND),
        },
        {
            parser(res) {
                return res.records;
            },
        },
    );
}
