import { CacheRequestContext } from 'shared/hooks/useCacheRequestContext/useCacheRequestContext';
import { useFetchRequest } from 'shared/hooks/useFetchRequest/useFetchRequest';

interface UseUserTagsReq {
    object_id: string;
    cache?: CacheRequestContext;
}

export interface UseUserTagsRes {
    deprecated: UserTag[];
    propositions: UserTag[];
    records: UserTag[];
    types: string[];
}

export interface UserTag {
    comment: string;
    display_name: string;
    default_priority: string;
    description_index: string;
    entities: string[];
    meta: unknown;
    name?: string;
    tag?: string;
    revision?: string;
    type?: string;
    tag_id?: string;
}

export function useUserTags(object_id: string) {
    return useFetchRequest<UseUserTagsReq, UseUserTagsRes>('/api/leasing/user/tag/list', { object_id });
}
