import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Back number': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Back number',
        ru: 'Обратный номер',
        cs: 'Číslo vzadu',
    },
    Birthday: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Birthday',
        ru: 'Дата рождения',
        cs: 'Narozeniny',
    },
    Categories: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Categories',
        ru: 'Категории',
        cs: 'Kategorie',
    },
    Country: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Country',
        ru: 'Страна',
        cs: 'Země',
    },
    'Front number': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Front number',
        ru: 'Лицевой номер',
        cs: 'Číslo vpředu',
    },
    'Issue date': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Issue date',
        ru: 'Дата выдачи',
        cs: 'Datum vydání',
    },
    Name: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Name',
        ru: 'Имя',
        cs: 'Jméno',
    },
    Surname: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Surname',
        ru: 'Фамилия',
        cs: 'Příjmení',
    },
    'Valid from date': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Valid from date',
        ru: 'Действует с',
        cs: 'Platnost od data',
    },
    'Valid to date': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Valid to date',
        ru: 'Действует по',
        cs: 'Platnost do data',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
