import { EMPTY_DATA } from 'constants/constants';

import { UserDrivingLicenseFormSchema } from 'entities/User/types/UserDrivingLicenseFormSchema';

import { i18n } from 'entities/User/helpers/getUserDocumentDriverLicenseField/getUserDocumentDriverLicenseField.i18n';

const FIELDS: Partial<Record<keyof UserDrivingLicenseFormSchema, string>> = {
    first_name: i18n('Name'),
    last_name: i18n('Surname'),
    front_country: i18n('Country'),
    birth_date: i18n('Birthday'),
    categories: i18n('Categories'),
    issue_date: i18n('Issue date'),
    categories_b_valid_from_date: i18n('Valid from date'),
    categories_b_valid_to_date: i18n('Valid to date'),
    number_front: i18n('Front number'),
    number_back: i18n('Back number'),
};

export function getUserDocumentDriverLicenseField(key: keyof UserDrivingLicenseFormSchema): string {
    return FIELDS[key] ?? EMPTY_DATA;
}
