import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    Birthday: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Birthday',
        ru: 'Дата рождения',
        cs: 'Narozeniny',
    },
    Country: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Country',
        ru: 'Страна',
        cs: 'Země',
    },
    Gender: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Gender',
        ru: 'Пол',
        cs: 'Pohlaví',
    },
    'Issue date': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Issue date',
        ru: 'Дата выдачи',
        cs: 'Datum vydání',
    },
    Name: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Name',
        ru: 'Имя',
        cs: 'Jméno',
    },
    'Passport number': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'REQUIRES_TRANSLATION',
            },
        },
        en: 'Passport number',
        ru: 'Номер паспорта',
        cs: '',
    },
    Surname: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Surname',
        ru: 'Фамилия',
        cs: 'Příjmení',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
