import { EMPTY_DATA } from 'constants/constants';

import { UserPassportFormSchema } from 'entities/User/types/UserPassportFormSchema';

import { i18n } from 'entities/User/helpers/getUserDocumentPassportField/getUserDocumentPassportField.i18n';

const FIELDS: Partial<Record<keyof UserPassportFormSchema, string>> = {
    first_name: i18n('Name'),
    last_name: i18n('Surname'),
    gender: i18n('Gender'),
    birth_date: i18n('Birthday'),
    citizenship: i18n('Country'),
    doc_value: i18n('Passport number'),
    issue_date: i18n('Issue date'),
};

export function getUserDocumentPassportField(key: keyof UserPassportFormSchema): string {
    return FIELDS[key] ?? EMPTY_DATA;
}
