import { EMPTY_DATA } from 'constants/constants';

import { UserPassportFormSchema } from 'entities/User/types/UserPassportFormSchema';

import { i18n } from 'entities/User/helpers/getUserDocumentPassportGender/getUserDocumentPassportGender.i18n';

const GENDER = {
    male: i18n('Male'),
    female: i18n('Female'),
};

export function getUserDocumentPassportGender(key: Optional<UserPassportFormSchema['gender']>): string {
    return key ? GENDER[key.toString()] ?? EMPTY_DATA : EMPTY_DATA;
}
