import { UseUserDocumentPhotoRes } from 'entities/User/api/useUser/useUser';
import { UserPhotoContentTypeSchema } from 'entities/User/types/UserPhotosSchema';

export interface DocumentPhotoDataRes {
    type: UserPhotoContentTypeSchema;
    userId?: string;
    photoId?: string;
    date?: Date;
}

export function getUserDocumentPhotoData(photos: UseUserDocumentPhotoRes): DocumentPhotoDataRes[] {
    return Object.keys(photos)?.map((key: UserPhotoContentTypeSchema) => {
        return {
            type: key,
            ...photos[key],
        };
    });
}
