import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    Admin: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Admin',
        ru: 'Администратор',
        cs: 'Správce',
    },
    Driver: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Driver',
        ru: 'Водитель',
        cs: 'Řidič',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
