import { EMPTY_DATA } from 'constants/constants';

import { UserRole } from 'entities/User/consts/UserRole';

import { i18n } from 'entities/User/helpers/getUserRoles/getUserRoles.i18n';

export function getUserRoles(roles: UserRole[]): string[] {
    return roles.map((role) => {
        switch (role) {
            case UserRole.ADMIN:
                return i18n('Admin');
            case UserRole.DRIVER:
                return i18n('Driver');
            default:
                return EMPTY_DATA;
        }
    });
}
